-- sm-ssc Default Theme Preferences Handler
function InitGamePrefs()
	local Prefs = 
	{
		{ "DefaultFail",	"Immediate" },
	};

	local BPrefs =
	{
		{ "ComboOnRolls",	false },
	};

	for idx,pref in ipairs(Prefs) do
		if GetGamePref( pref[1] ) == nil then
			SetGamePref( pref[1], pref[2] );
		end;
	end;
	
	for idx,pref in ipairs(BPrefs) do
		if GetGamePrefB( pref[1] ) == nil then
			SetGamePref( pref[1], pref[2] );
		end;
	end;
end

function GetProTiming(pn)
	local pname = ToEnumShortString(pn);
	if GetUserPref("ProTiming"..pname) then
		return GetUserPrefB("ProTiming"..pname);
	else
		SetUserPref("ProTiming"..pname,false);
		return false;
	end;
end;

function GetDefaultOptionLines()
	local LineSets = {
		"1,8,14,2,3,4,5,6,R,7,9,10,11,12,13,15,16,SF,17,18", -- All
		"1,8,14,2,7,13,16,SF,17,18", -- DDR Essentials ( no turns, fx )
	};
	local function IsExtra()
		if GAMESTATE:IsExtraStage() or GAMESTATE:IsExtraStage2() then
			return true
		else
			return false
		end
	end
	if not IsExtra() then
		if GetUserPrefB("UserPrefShowLotsaOptions") then
			return GetUserPrefB("UserPrefShowLotsaOptions") and LineSets[1] or LineSets[2];
		else
			return LineSets[2]; -- Just make sure!
		end
	else
		return "1,8,14,2,7,13,16,SF,17,18" -- "failsafe" list
	end
end;

--[[ end themeoption rows ]]

--[[ game option rows ]]
function GamePrefDefaultFail()
	local t = {
		Name = "GamePrefDefaultFail";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { "Immediate","ImmediateContinue", "AtEnd", "Off" };
		LoadSelections = function(self, list, pn)
			if ReadGamePrefFromFile("DefaultFail") ~= nil then
				if GetGamePref("DefaultFail") then
					if GetGamePref("DefaultFail") == "Immediate" then
						list[1] = true;
					elseif GetGamePref("DefaultFail") == "ImmediateContinue" then
						list[2] = true;
					elseif GetGamePref("DefaultFail") == "AtEnd" then
						list[3] = true;
					elseif GetGamePref("DefaultFail") == "Off" then
						list[4] = true;
					else
						list[1] = true;
					end
					-- list[table.find( list, GetGamePref("DefaultFail") )] = true;
				else
					list[1] = true;
				end;
			else
				WriteGamePrefToFile("DefaultFail","Immediate");
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			-- This is so stupid.
			local tChoices = { "Immediate","ImmediateContinue", "AtEnd", "Off" };
			local val;
			if list[1] then
				val = tChoices[1];
			elseif list[2] then
				val = tChoices[2];
			elseif list[3] then
				val = tChoices[3];
			elseif list[4] then
				val = tChoices[4];
			else
				val = tChoices[1];
			end
			WriteGamePrefToFile("DefaultFail",val);
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" } );
			THEME:ReloadMetrics();
		end;
	};
	setmetatable( t, t );
	return t;
end
